//
//  MCMenuManager.h
//  MCApplication
//
//  Created by Ali Lalani on 10/6/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCUserDefaults;

@interface MCMenuManager : NSObject {
	NSMutableDictionary *_menuItemActions;
}
+ (MCMenuManager *)defaultManager;

#pragma mark Conveniences
- (id)targetForSelectorNamed:(NSString *)aSelector;
- (BOOL)validateObjects:(NSArray *)objs forSelectorNamed:(NSString *)sel;

#pragma mark Messaging
- (BOOL)originatingController:(id)anObj respondsToSelector:(SEL)aSelector
			   forObjects:(NSArray *)objs;
- (BOOL)originatingController:(id)anObj respondsToSelector:(SEL)aSelector
				   forObjects:(NSArray *)objs
				parentObjects:(NSArray *)parentObjs;
- (BOOL)originatingController:(id)anObj validateMenuItem:(NSMenuItem *)anItem
			selectorNamed:(NSString *)aSelector
			   forObjects:(NSArray *)objs;
- (BOOL)originatingController:(id)anObj validateMenuItem:(NSMenuItem *)anItem
				selectorNamed:(NSString *)aSelector
				   forObjects:(NSArray *)objs
				parentObjects:(NSArray *)parentObjs;
- (NSMethodSignature *)originatingController:(id)anObj methodSignatureForSelector:(SEL)aSelector;
- (BOOL)originatingController:(id)anObj forwardInvocation:(NSInvocation *)anInvocation
			   forObjects:(NSArray *)objs;
- (BOOL)originatingController:(id)anObj forwardInvocation:(NSInvocation *)anInvocation
				   forObjects:(NSArray *)objs
				parentObjects:(NSArray *)parentObjs;
#pragma mark Registration
- (void)registerMenuItemActionWithDisplayString:(NSString *)ds actionString:(NSString *)selString applicableClassnames:(NSArray *)classNames 
								   commandClass:(id)aClass multipleObjectTypesPerAction:(BOOL)multiFlag
								alwaysValidates:(BOOL)avFlag;
- (void)registerMenuItemAction:(NSDictionary *)conf forSelectorNamed:(NSString *)ident;
- (void)registerMenuItemActions:(NSArray *)configs;

#pragma mark ContextualMenu
- (NSMenu *)menuForContextualMenuDelegate:(id)deleg extraItems:(NSArray *)extraItems;

#pragma mark Accessors
- (NSMutableDictionary *)menuItemActions;
- (void)setMenuItemActions:(NSMutableDictionary *)aMenuItemActions;
@end

@interface NSObject (MCMenuManagerContextualMenuDelegate)
- (NSArray *)menuManagerExtraMenuItems;
@end

@interface NSObject (MCMenuManagerActionHandler)
- (IBAction)menuNeedsUpdate:(NSMenu *)menu forSelector:(SEL)selector withRepresentedObject:(id)rep;
@end
